<?php
require_once dirname(__FILE__) . '/../TestUnitDB.php';

class TyghSuite
{
    private static $suite;

    public static function suite()
    {
        self::$suite = new PHPUnit_Framework_TestSuite('CS-Cart classes test');

        self::addTestsDir(DIR_ROOT . "/_tools/unit_tests/Tygh/Tools", true);
        self::addTestsDir(DIR_ROOT . "/_tools/unit_tests/Tygh/Core", true);
        self::addTestsDir(DIR_ROOT . "/_tools/unit_tests/Tygh/Shippings", true);
        self::addTestsDir(DIR_ROOT . "/_tools/unit_tests/Tygh/Languages", true);
        self::addTestsDir(DIR_ROOT . "/_tools/unit_tests/Tygh/Api/Entities", true);

        return self::$suite;
    }

    private static function addTestsDir($dir, $in = false)
    {
        if (is_dir($dir)) {
            $dirs = fn_get_dir_contents($dir, true, false);
            $files = fn_get_dir_contents($dir, false, $in);

            foreach ($dirs as $inc_dir) {
                self::addTestsDir($dir . "/" . $inc_dir, true);
            }
            foreach ($files as $file) {
                require_once($dir . "/" . $file);
                $className = substr(basename($file), 0, -4);

                if (class_exists($className)) {
                    self::$suite->addTestSuite($className);
                } else {
                    $namespace = str_replace(array(DIR_ROOT . '/_tools/unit_tests', '/'), array('', '\\'), $dir);
                    self::$suite->addTestSuite($namespace . '\\' . $className);
                }
            }
        }
    }
}
