<?php
/***************************************************************************
*                                                                          *
*   (c) 2004 Vladimir V. Kalynyak, Alexey V. Vinokurov, Ilya M. Shalnev    *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
if (!defined('BOOTSTRAP')) { die('Access denied'); }

/**
 * DO NOT EDIT THIS FILE
 *
 * This file defines and sets all the necessary parameters for the proper operation of the system and should not be edited,
 * as it may be completely overwritten during a system update.
 * If you want to customize these parameters, make your changes in config.local.php.
 */

/*
 * Static options
 */

define('NEW_FEATURE_GROUP_ID', 'OG');

// Week days
define('SUNDAY',    0);
define('MONDAY',    1);
define('TUESDAY',   2);
define('WEDNESDAY', 3);
define('THURSDAY',  4);
define('FRIDAY',    5);
define('SATURDAY',  6);

// statuses definitions
define('STATUSES_ORDER', 'O');
define('STATUSES_SHIPMENT', 'S');

/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::INCOMPLETED instead.
 *
 * @see \Tygh\Enum\OrderStatuses::INCOMPLETED
 */
define('STATUS_INCOMPLETED_ORDER', 'N');
/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::PARENT instead.
 *
 * @see \Tygh\Enum\OrderStatuses::PARENT
 */
define('STATUS_PARENT_ORDER', 'T');
/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::BACKORDERED instead.
 *
 * @see \Tygh\Enum\OrderStatuses::BACKORDERED
 */
define('STATUS_BACKORDERED_ORDER', 'B');
/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::CANCELED instead.
 *
 * @see \Tygh\Enum\OrderStatuses::CANCELED
 */
define('STATUS_CANCELED_ORDER', 'I');

//Login statuses
define('LOGIN_STATUS_USER_NOT_FOUND', '0');
define('LOGIN_STATUS_OK', '1');
define('LOGIN_STATUS_USER_DISABLED', '2');

// usergroup definitions
define('ALLOW_USERGROUP_ID_FROM', 3);
define('ALL_USERGROUPS', -1);
define('USERGROUP_ALL', 0);
define('USERGROUP_GUEST', 1);
define('USERGROUP_REGISTERED', 2);

// Recovery password settings
define('RECOVERY_PASSWORD_EKEY_TYPE', 'R');

// SEF urls delimiter
define('SEO_DELIMITER', '-');

// Number of seconds in one hour (for different calculations)
define('SECONDS_IN_HOUR', 60 * 60); // one hour

// Number of seconds in one day (for different calculations)
define('SECONDS_IN_DAY', SECONDS_IN_HOUR * 24); // one day

//Uncomment to enable the developer tools: debugger, PHP and SQL loggers, etc.
//define('DEBUG_MODE', true);

//Uncomment to enable error reporting.
//define('DEVELOPMENT', true);

// Theme description file name
define('THEME_MANIFEST', 'manifest.json');
define('THEME_MANIFEST_INI', 'manifest.ini');

// Controller return statuses
define('CONTROLLER_STATUS_REDIRECT', 302);
define('CONTROLLER_STATUS_OK', 200);
define('CONTROLLER_STATUS_NO_CONTENT', 204);
define('CONTROLLER_STATUS_NO_PAGE', 404);
define('CONTROLLER_STATUS_DENIED', 403);
define('CONTROLLER_STATUS_DEMO', 401);

define('INIT_STATUS_OK', 1);
define('INIT_STATUS_REDIRECT', 2);
define('INIT_STATUS_FAIL', 3);

define('PLACE_ORDER_STATUS_OK', 1);
define('PLACE_ORDER_STATUS_TO_CART', 2);
define('PLACE_ORDER_STATUS_DENIED', 3);

// Database default tables prefix
define('DEFAULT_TABLE_PREFIX', 'cscart_');

define('CS_PHP_VERSION', phpversion());

// Product information
define('PRODUCT_NAME', 'Multi-Vendor');
define('PRODUCT_VERSION', '4.19.1.SP2');
define('PRODUCT_RELEASE_TIMESTAMP', 1761004800);
define('PRODUCT_STATUS', '');


define('PRODUCT_EDITION', 'MULTIVENDOR');
define('PRODUCT_BUILD', '');


if (!defined('ACCOUNT_TYPE')) {
    define('ACCOUNT_TYPE', 'customer');
}

define('BILLING_ADDRESS_PREFIX', 'b');
define('SHIPPING_ADDRESS_PREFIX', 's');

//User data type for admin theme mode
define('BACKOFFICE_COLOR_SCHEME', 'T');

// Log everything, but do not display
error_reporting(E_ALL);
ini_set('display_errors', 0);

if (!defined('CONSOLE')) {
    // Set maximum time limit for script execution.
    @set_time_limit(3600);
}

/*
 * Dynamic options
 */
$config = array();

// Names of index files for the frontend and backend
$config['customer_index'] = 'index.php';
$config['admin_index']    = 'admin.php';
$config['vendor_index']   = 'vendor.php';

$config['dir'] = array(
    'root' => DIR_ROOT,
    'functions' => DIR_ROOT . '/app/functions/',
    'lib' => DIR_ROOT . '/app/lib/',
    'addons' => DIR_ROOT . '/app/addons/',
    'design_frontend' => DIR_ROOT . '/design/themes/',
    'design_backend' => DIR_ROOT . '/design/backend/',
    'payments' => DIR_ROOT . '/app/payments/',
    'schemas' => DIR_ROOT . '/app/schemas/',
    'themes_repository' => DIR_ROOT . '/var/themes_repository/',
    'database' => DIR_ROOT . '/var/database/',
    'var' => DIR_ROOT . '/var/',
    'upgrade' => DIR_ROOT . '/var/upgrade/',
    'cache_templates' => DIR_ROOT . '/var/cache/templates/',
    'cache_mail_templates' => DIR_ROOT . '/var/cache/templates/mail/',
    'cache_twig_templates' => DIR_ROOT . '/var/cache/templates/twig/',
    'cache_registry' => DIR_ROOT . '/var/cache/registry/',
    'files' => DIR_ROOT . '/var/files/',
    'cache_misc' => DIR_ROOT . '/var/cache/misc/',
    'cache_static' => DIR_ROOT . '/var/cache/static/',
    'layouts' => DIR_ROOT . '/var/layouts/',
    'snapshots' => DIR_ROOT . '/var/snapshots/',
    'lang_packs' => DIR_ROOT . '/var/langs/',
    'certificates' => DIR_ROOT . '/var/certificates/',
    'store_import' => DIR_ROOT . '/var/store_import/',
    'backups' => DIR_ROOT . '/var/backups/',
);

// List of forbidden file extensions (for uploaded files)
$config['forbidden_file_extensions'] = array (
    'php',
    'php3',
    'pl',
    'com',
    'exe',
    'bat',
    'cgi',
    'htaccess',
    'svg',
);

$config['forbidden_mime_types'] = array (
    'text/x-php',
    'text/x-perl',
    'text/x-python',
    'text/x-shellscript',
    'application/x-executable',
    'application/x-ms-dos-executable',
    'application/x-cgi',
    'application/x-extension-htaccess',
    'application/x-msdownload',
    'image/svg+xml',
);

$config['allowed_image_extensions'] = [
    'jpg',
    'jpeg',
    'png',
    'gif',
    'ico',
    'webp',
];

$config['sanitize_user_html_allowed_iframe_domains'] = [
    'www.youtube.com',
    'www.youtube-nocookie.com',
    'player.vimeo.com'
];

$config['js_css_cache_msg'] = "/*
ATTENTION! Please do not modify this file, it's auto-generated and all your changes will be lost.
The complete list of files it's generated from:
[files]
*/

";

$config['base_theme'] = 'responsive';

// FIXME: backward compatibility
// Updates server address
$config['updates_server'] = 'https://updates.cs-cart.com';

// external resources, related to product
$config['resources'] = array(
    'docs_url'                      => 'https://docs.cs-cart.com/4.19.x/',
    'knowledge_base'                => 'https://docs.cs-cart.com/4.19.x/install/index.html',
    'faq'                           => 'https://www.cs-cart.com/faq.html',
    'updates_server'                => 'https://updates.cs-cart.com',
    'twitter'                       => 'cscart',
    'feedback_api'                  => 'https://helpdesk.cs-cart.com/index.php?dispatch=feedback',
    'product_url'                   => 'https://www.cs-cart.com',
    'helpdesk_url'                  => 'https://helpdesk.cs-cart.com/helpdesk',
    'license_url'                   => 'https://www.cs-cart.com/licenses.html',
    'ultimate_license_url'          => 'https://www.cs-cart.com/cs-cart-ultimate-license.html',
    'standard_license_url'          => 'https://www.cs-cart.com/cs-cart-license.html',
    'download'                      => 'https://www.cs-cart.com/download-multivendor.html',
    'demo_product_buy_url'          => 'https://helpdesk.cs-cart.com/multi-vendor-licenses.html',
    'mve_plus_license_url'          => 'https://www.cs-cart.com/multi-vendor-plus-license.html',
    'mve_ultimate_license_url'      => 'https://www.cs-cart.com/multi-vendor-ultimate-license.html',
    'marketplace_url'               => 'https://marketplace.cs-cart.com',
    'admin_protection_url'          => 'https://docs.cs-cart.com/4.19.x/install/security.html#step-1-rename-admin-php',
    'widget_mode_url'               => 'https://docs.cs-cart.com/4.19.x/user_guide/look_and_feel/layouts/widget_mode/index.html',
    'developers_catalog'            => 'https://marketplace.cs-cart.com/developers-catalog.html',
    'upgrade_center_specialist_url' => 'https://marketplace.cs-cart.com/developers-catalog.html?services=M',
    'upgrade_center_team_url'       => 'https://www.cs-cart.com/index.php?dispatch=communication.tickets&submit_ticket=Y',
    'kb_https_failed_url'           => 'https://docs.cs-cart.com/4.19.x/install/possible_issues/secure_connection_failed.html',
    'curl_error_interpretation'     => 'https://curl.haxx.se/libcurl/c/libcurl-errors.html',
    'product_buy_url'               => 'https://www.cs-cart.com/multivendor.html?utm_source=trial',
    'forum'                         => 'https://forum.cs-cart.com/',
    'bug_tracker_url'               => 'https://forum.cs-cart.com/index.php?app=tracker&module=post&section=post&do=postnew&pid=11&new_module_versions_id=138',
    'core_addons_supplier_url'      => 'https://helpdesk.cs-cart.com',
    'docs_guideline'                => 'https://docs.cs-cart.com/4.19.x/developer_guide/getting_started/guidelines.html',
    'translate'                     => 'https://translate.cs-cart.com',
    'changelog_url'                 => 'https://docs.cs-cart.com/latest/history/index.html',
    'video_tutorials'               => 'https://www.cs-cart.com/cs-cart-video-tutorials.html',
);

$config['lazy_thumbnails'] = array(
    'max_width'  => 1280,
    'max_height' => 720
);

// Enable UI components
$config['simple_dashboard'] = true;

// Debugger token
$config['debugger_token'] = 'debug';
$config['allowed_pack_exts'] = ['tgz', 'gz', 'zip'];

$config['helpdesk'] = [
    'url'           => 'https://helpdesk.cs-cart.com',
    'client_id'     => 'cs-cart',
    'client_secret' => 'd3d407a7096a56fa127ce9109ba1d5aa2afb8bb6',
];

// API key for Alpha Vantage (exchange rates) -> https://www.alphavantage.co/support/
$config['alpha_vantage_api_key'] = 'X24PW1QRZI0I3UAO';

// Cache backend
// Available backends: file, sqlite, database, redis, xcache, apc, apcu
// To use sqlite cache the "sqlite3" PHP module should be installed
// To use xcache cache the "xcache" PHP module should be installed
// To use apc cache the "apc" PHP module should be installed
// To use apcu cache the PHP version should be >= 7.x and the "apcu" PHP module should be installed
$config['cache_backend'] = 'file';
$config['cache_redis_server'] = 'localhost';
$config['cache_redis_global_ttl'] = 0; // set this if your cache size reaches Redis server memory size

// Storage backend for sessions. Available backends: database, redis
$config['session_backend'] = 'database';
$config['session_redis_server'] = 'localhost';
$config['cache_apc_global_ttl'] = 0;
$config['cache_xcache_global_ttl'] = 0;

// Lock backend
// Available backends: database, redis, dummy
// To disable locks use dummy provider
$config['lock_backend'] = 'database';
$config['lock_redis_server'] = 'localhost';
$config['lock_redis_server_password'] = null;

// Set to unique store prefix if you use the same Redis/Xcache/Apc storage
// for serveral cart installations
$config['store_prefix'] = '';

// CDN server backend
$config['cdn_backend'] = 'cloudfront';

// Storage options
$config['storage'] = [
    'images' => [
        'prefix' => 'images',
        'dir'    => $config['dir']['root'],
        'cdn'    => true
    ],
    'downloads' => [
        'prefix'  => 'downloads',
        'secured' => true,
        'dir'     => $config['dir']['var']
    ],
    'assets' => [
        'dir'    => & $config['dir']['cache_misc'],
        'prefix' => 'assets',
        'cdn'    => true
    ],
    'custom_files' => [
        'dir'    => & $config['dir']['var'],
        'prefix' => 'custom_files'
    ]
];

// Tweaks
$config['tweaks'] = [];

// DEMO mode
$config['demo_mode'] = false;

// Get local configuration
require_once($config['dir']['root'] . '/config.local.php');

// Tweaks
// Whether to remove any javascript code from description and name of product, category, etc.
// Auto - false for ULT, true for MVE.
$config['tweaks']['sanitize_user_html']                              = $config['tweaks']['sanitize_user_html'] ?? 'auto';
$config['tweaks']['anti_csrf']                                       = $config['tweaks']['anti_csrf'] ?? true; // protect forms from CSRF attacks
$config['tweaks']['disable_block_cache']                             = $config['tweaks']['disable_block_cache'] ?? false; // used to disable block cache
$config['tweaks']['disable_localizations']                           = $config['tweaks']['disable_localizations'] ?? true; // Disable Localizations functionality
$config['tweaks']['disable_dhtml']                                   = $config['tweaks']['disable_dhtml'] ?? false; // Disable Ajax-based pagination and Ajax-based "Add to cart" button
$config['tweaks']['do_not_apply_promotions_on_order_update']         = $config['tweaks']['do_not_apply_promotions_on_order_update'] ?? true; // If true, the promotions that applied to the order won't be changed when editing the order. New promotions won't be applied to the order.
$config['tweaks']['dev_js']                                          = $config['tweaks']['dev_js'] ?? false; // set to true to disable js files compilation
$config['tweaks']['redirect_to_cart']                                = $config['tweaks']['redirect_to_cart'] ?? false; // Redirect customer to the cart contents page. Used with the "disable_dhtml" setting.
$config['tweaks']['api_https_only']                                  = $config['tweaks']['api_https_only'] ?? false; // Allows the use the API functionality only by the HTTPS protocol
$config['tweaks']['api_allow_customer']                              = $config['tweaks']['api_allow_customer'] ?? false; // Allow open API for unauthorized customers
$config['tweaks']['lazy_thumbnails']                                 = $config['tweaks']['lazy_thumbnails'] ?? false; // generate image thumbnails on the fly
$config['tweaks']['image_resize_lib']                                = $config['tweaks']['image_resize_lib'] ?? 'auto'; // library to resize images - "auto", "gd" or "imagick"
$config['tweaks']['products_found_rows_no_cache_limit']              = $config['tweaks']['products_found_rows_no_cache_limit'] ?? 100; // Max count of SQL found rows without saving to cache
$config['tweaks']['show_database_changes']                           = $config['tweaks']['show_database_changes'] ?? false; // Show database changes in View changes tool
$config['tweaks']['backup_db_mysqldump']                             = $config['tweaks']['backup_db_mysqldump'] ?? false; // Backup database using mysqldump when available
$config['tweaks']['allow_product_filters_to_create_temporary_table'] = $config['tweaks']['allow_product_filters_to_create_temporary_table'] ?? true; // Allows product filters to create temporary table for products query
$config['tweaks']['request_errors_threshold']                        = $config['tweaks']['request_errors_threshold'] ?? 30; // Threshold for the number of errors when an email realtime delivery error notification is triggered
$config['tweaks']['profile_field_max_upload_filesize']               = $config['tweaks']['profile_field_max_upload_filesize'] ?? '10M'; //Limit max upload file size for profile fields
$config['tweaks']['validate_menu']                                   = $config['tweaks']['validate_menu'] ?? true; // Disable option to add any new element to top and central admin panel menu and to Add-ons top menu element.
$config['tweaks']['secure_cookies']                                  = $config['tweaks']['secure_cookies'] ?? true; // Allow to set "Secure" flag to cookies, if your store works with HTTPS. P.S. All users will be log out, also, all abandoned carts will lost.
$config['tweaks']['cors_allowlist']                                  = $config['tweaks']['cors_allowlist'] ?? []; // CORS enabled domains, e.g. ['domain1.com', 'domain2.com']
$config['tweaks']['csp_frame_ancestors']                             = $config['tweaks']['csp_frame_ancestors'] ?? []; // The HTTP Content-Security-Policy (CSP) frame-ancestors directive specifies valid parents that may embed a page using <frame>, <iframe>, <object>, <embed>, or <applet>.
$config['tweaks']['allow_global_individual_settings']                = $config['tweaks']['allow_global_individual_settings'] ?? true; // Allow global individual settings (Track inventory, Options type, Zero price action etc.)
$config['tweaks']['show_marketplace_logs']                           = $config['tweaks']['show_marketplace_logs'] ?? false; // Allow to show logs of all requests to marketplace
$config['tweaks']['disable_resource_preloading']                     = $config['tweaks']['disable_resource_preloading'] ?? false; // Allows to disable resource preloading for the theme
$config['tweaks']['max_fonts_to_preload']                            = $config['tweaks']['max_fonts_to_preload'] ?? 1; // Maximum amount of fonts to preload
$config['tweaks']['show_helpdesk_logs']                              = $config['tweaks']['show_helpdesk_logs'] ?? false; // Allows showing logs of all requests to Help Desk service
$config['tweaks']['download_upgrade_package_timeout']                = $config['tweaks']['download_upgrade_package_timeout'] ?? 180; // Allows changing timeout for upgrade package download if server has low download speed
$config['tweaks']['logo_max_upload_filesize_in_bytes']               = $config['tweaks']['logo_max_upload_filesize_in_bytes'] ?? 1048576; // Limit max upload filesize for application logos
$config['tweaks']['upgrade_center_package_cache_ttl']                = $config['tweaks']['upgrade_center_package_cache_ttl'] ?? SECONDS_IN_HOUR * 3;
$config['tweaks']['marketplace_request_cache_ttl']                   = $config['tweaks']['marketplace_request_cache_ttl'] ?? SECONDS_IN_HOUR * 3;

// These constants define when select box with categories list should be replaced with picker
defined('CATEGORY_THRESHOLD') or define('CATEGORY_THRESHOLD', 100); // if number of categories less than this value, all categories will be retrieved, otherwise subcategories will be retrieved by ajax
defined('CATEGORY_SHOW_ALL') or define('CATEGORY_SHOW_ALL', 100);  // if number of categories less than this value, categories tree will be expanded

// These constants define when select box with pages list should be replaced with picker
defined('PAGE_THRESHOLD') or define('PAGE_THRESHOLD', 40); // if number of pages less than this value, all pages will be retrieved, otherwise subpages will be retrieved by ajax
defined('PAGE_SHOW_ALL') or define('PAGE_SHOW_ALL', 100); // if number of pages less than this value, pages tree will be expanded

// These constants define when select box with product feature variants list should be replaced with picker
defined('PRODUCT_FEATURE_VARIANTS_THRESHOLD') or define('PRODUCT_FEATURE_VARIANTS_THRESHOLD', 40); // if number of product feature variants less than this value, all product feature variants will be retrieved, otherwise product features variants will be retrieved by ajax

// Maximum number of recently viewed products, stored in session
defined('MAX_RECENTLY_VIEWED') or define('MAX_RECENTLY_VIEWED', 10);

// The maximum allowed value of the "Initial order ID value" in Settings: General
defined('MAX_INITIAL_ORDER_ID') or define('MAX_INITIAL_ORDER_ID', 10000000);

// Number of product features per page to display on product details page in admin panel
defined('PRODUCT_FEATURES_THRESHOLD') or define('PRODUCT_FEATURES_THRESHOLD', 50);

// Authentication settings
defined('USER_PASSWORD_LENGTH') or define('USER_PASSWORD_LENGTH', '8');
defined('USER_ONE_TIME_PASSWORD_LENGTH') or define('USER_ONE_TIME_PASSWORD_LENGTH', 6);
defined('USER_ONE_TIME_PASSWORD_ATTEMPTS') or define('USER_ONE_TIME_PASSWORD_ATTEMPTS', 5);

// Recovery password settings
defined('RECOVERY_PASSWORD_EKEYS_LIMIT') or define('RECOVERY_PASSWORD_EKEYS_LIMIT', 3);
defined('RECOVERY_PASSWORD_TTL') or define('RECOVERY_PASSWORD_TTL', 900);

// Live time for permanent cookies (currency, language, etc...)
defined('COOKIE_ALIVE_TIME') or define('COOKIE_ALIVE_TIME', SECONDS_IN_DAY * 7); // one week

// Session live time
defined('SESSION_ALIVE_TIME') or define('SESSION_ALIVE_TIME', SECONDS_IN_HOUR * 2); // 2 hours

// Sessions storage live time
defined('SESSIONS_STORAGE_ALIVE_TIME') or define('SESSIONS_STORAGE_ALIVE_TIME', SECONDS_IN_DAY * 7 * 2); // 2 weeks

// Number of seconds after last session update, while user considered as online
defined('SESSION_ONLINE') or define('SESSION_ONLINE', 60 * 5); // 5 minutes

// Number of seconds before installation script will be redirected to itself to avoid server timeouts
defined('INSTALL_DB_EXECUTION') or define('INSTALL_DB_EXECUTION', SECONDS_IN_HOUR); // 1 hour

// Maximum number of items in "Last edited items" list (in the backend)
defined('LAST_EDITED_ITEMS_COUNT') or define('LAST_EDITED_ITEMS_COUNT', 10);

// Meta description auto generation
defined('AUTO_META_DESCRIPTION') or define('AUTO_META_DESCRIPTION', true);

//Popularity rating
defined('POPULARITY_VIEW') or define('POPULARITY_VIEW', 3);
defined('POPULARITY_ADD_TO_CART') or define('POPULARITY_ADD_TO_CART', 5);
defined('POPULARITY_DELETE_FROM_CART') or define('POPULARITY_DELETE_FROM_CART', 5);
defined('POPULARITY_BUY') or define('POPULARITY_BUY', 10);

// Session options
// defined('SESS_VALIDATE_IP') or define('SESS_VALIDATE_IP', true); // link session ID with ip address
defined('SESS_VALIDATE_UA') or define('SESS_VALIDATE_UA', true); // link session ID with user-agent

defined('DB_MAX_ROW_SIZE') or define('DB_MAX_ROW_SIZE', 10000);
defined('DB_ROWS_PER_PASS') or define('DB_ROWS_PER_PASS', 400);

// Default permissions for newly created files and directories
defined('DEFAULT_FILE_PERMISSIONS') or define('DEFAULT_FILE_PERMISSIONS', 0666);
defined('DEFAULT_DIR_PERMISSIONS') or define('DEFAULT_DIR_PERMISSIONS', 0777);

// Maximum number of files, stored in directory. You may change this parameter straight after a store was installed. And you must not change it when the store has been populated with products already.
defined('MAX_FILES_IN_DIR') or define('MAX_FILES_IN_DIR', 1000);

defined('MAILING_LIST_ID') or define('MAILING_LIST_ID', 1);

// Backward compatibility
if (!empty($config['saas_uid']) && empty($config['store_prefix'])) {
    $config['store_prefix'] = $config['saas_uid'];
}

// Define host directory depending on the current connection
$config['current_path'] = (defined('HTTPS')) ? $config['https_path'] : $config['http_path'];

$config['http_location'] = 'http://' . $config['http_host'] . $config['http_path'];
$config['https_location'] = 'https://' . $config['https_host'] . $config['https_path'];
$config['current_location'] = (defined('HTTPS')) ? $config['https_location'] : $config['http_location'];
$config['current_host'] = (defined('HTTPS')) ? $config['https_host'] : $config['http_host'];

return $config;
