<?php

namespace Tygh\Api\Entities;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

use Tygh\Enum\ProductFeatures;
use Tygh\Api\Entities\Features;
use Tygh\Api\Response;
/**
 * Tests API Features entity
 */
class FeaturesTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Features
     */
    protected $api;

    protected function setUp()
    {
        parent::setUp();

        $this->api = new Features(array(
            'area' => 'A',
            'user_id' => '1',
            'user_type' => 'A',
            'tax_exempt' => 'N',
            'last_login' => '1343637055',
            'usergroup_ids' => array ( ),
            'order_ids' => array ( ),
            'act_as_user' => false,
            'this_login' => 1343652763,
            'password_change_timestamp' => 0,
            'company_id' => 0,
            'is_root' => 'Y',
            'referer' => '',
            'ip' => '192.168.1.111',
            'first_expire_check' => false
        ));

    }

    protected function tearDown()
    {
    }

    protected function dsProvider()
    {
        $data = array(
            'product_features.xml',
            'product_features_descriptions.xml',
            'product_features_values.xml',
        );

        if (fn_allowed_for('ULTIMATE')) {
            $data[] = 'ult_objects_sharing_1.xml';
        }

        return $data;
    }

    /**
     *
     * @dataProvider providerIndex()
     * @datasetProvider dsProvider
     */
    public function testIndex($id, $params, $result)
    {
        $actual = $this->api->index($id, $params);
        $this->assertEquals($result, $actual);
    }

    public function providerIndex()
    {
        $params = array(
            'product_id' => 0,
            'category_ids' => array(),
            'statuses' => array('A'),
            'variants' => false,
            'plain' => true,
            'feature_types' => array(),
            'feature_id' => 0,
            'display_on' => '',
            'exclude_group' => false,
            'exclude_filters' => false,
            'page' => 1,
            'items_per_page' => '10',
            'variants_selected_only' => false,
            'get_descriptions' => true,
            'total_items' => '4',
            'existent_only' => false,
            'skip_variants_threshould' => false,
            'variants_only' => null,

        );

        return array(
            // Get list
            array('', array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'features' => array(
                        array(
                            'feature_id' => '14',
                            'company_id' => '1',
                            'feature_type' =>  ProductFeatures::GROUP,
                            'parent_id' => '0',
                            'display_on_product' => 'Y',
                            'display_on_catalog' => 'Y',
                            'display_on_header' => 'N',
                            'description' => 'Electronics',
                            'lang_code' => 'en',
                            'prefix' => '',
                            'suffix' => '',
                            'categories_path' => '166,174,190,191,193',
                            'full_description' => '',
                            'status' => 'A',
                            'comparison' => 'N',
                            'position' => '0',
                        ),
                        array(
                            'feature_id' => '19',
                            'company_id' => '1',
                            'feature_type' => ProductFeatures::TEXT_FIELD,
                            'parent_id' => '0',
                            'display_on_product' => 'Y',
                            'display_on_catalog' => 'N',
                            'display_on_header' => 'N',
                            'description' => 'Text feature',
                            'lang_code' => 'en',
                            'prefix' => 'some_prefix',
                            'suffix' => '',
                            'categories_path' => '',
                            'full_description' => '<p>description for test feature</p>',
                            'status' => 'A',
                            'comparison' => 'N',
                            'position' => '33',
                            'group_position' => null,
                        ),
                        array(
                            'feature_id' => '15',
                            'company_id' => '1',
                            'feature_type' => ProductFeatures::TEXT_SELECTBOX,
                            'parent_id' => '14',
                            'display_on_product' => 'Y',
                            'display_on_catalog' => 'N',
                            'display_on_header' => 'N',
                            'description' => 'Operating System',
                            'lang_code' => 'en',
                            'prefix' => '',
                            'suffix' => '',
                            'categories_path' => '166,174,190,191,193',
                            'full_description' => '',
                            'status' => 'A',
                            'comparison' => 'N',
                            'position' => '10',
                            'group_position' => '0',
                        ),
                        array(
                            'feature_id' => '18',
                            'company_id' => '1',
                            'feature_type' => ProductFeatures::TEXT_SELECTBOX,
                            'parent_id' => '14',
                            'display_on_product' => 'N',
                            'display_on_catalog' => 'N',
                            'display_on_header' => 'N',
                            'description' => 'Disk Capacity',
                            'lang_code' => 'en',
                            'prefix' => '',
                            'suffix' => '',
                            'categories_path' => '166,174,190,191,193',
                            'full_description' => '',
                            'status' => 'A',
                            'comparison' => 'N',
                            'position' => '30',
                            'group_position' => '0',
                        ),
                        array(
                            'feature_id' => '17',
                            'company_id' => '1',
                            'feature_type' => ProductFeatures::TEXT_SELECTBOX,
                            'parent_id' => '14',
                            'display_on_product' => 'Y',
                            'display_on_catalog' => 'Y',
                            'display_on_header' => 'N',
                            'description' => 'Storage Capacity',
                            'lang_code' => 'en',
                            'prefix' => '',
                            'suffix' => '',
                            'categories_path' => '166,174,190,191,193',
                            'full_description' => '',
                            'status' => 'A',
                            'comparison' => 'N',
                            'position' => '30',
                            'group_position' => '0',
                        ),
                    ),

                    'params' => $params,
                ),
            )),

            array(14, array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'feature_id' => '14',
                    'company_id' => '1',
                    'feature_type' => ProductFeatures::GROUP,
                    'parent_id' => '0',
                    'display_on_product' => 'Y',
                    'display_on_catalog' => 'Y',
                    'display_on_header' => 'N',
                    'description' => 'Electronics',
                    'lang_code' => 'en',
                    'prefix' => '',
                    'suffix' => '',
                    'categories_path' => '166,174,190,191,193',
                    'full_description' => '',
                    'status' => 'A',
                    'comparison' => 'N',
                    'position' => '0',
                    'feature_code' => '',
                    'variants' => array()
                ),
            )),

            array(0, array('feature_types' => ProductFeatures::GROUP), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'features' => array(
                        array(
                            'feature_id' => '14',
                            'company_id' => '1',
                            'feature_type' => ProductFeatures::GROUP,
                            'parent_id' => '0',
                            'display_on_product' => 'Y',
                            'display_on_catalog' => 'Y',
                            'display_on_header' => 'N',
                            'description' => 'Electronics',
                            'lang_code' => 'en',
                            'prefix' => '',
                            'suffix' => '',
                            'categories_path' => '166,174,190,191,193',
                            'full_description' => '',
                            'status' => 'A',
                            'comparison' => 'N',
                            'position' => '0',
                            'group_position' => null
                        ),
                    ),

                    'params' => array(
                        'product_id' => 0,
                        'category_ids' => array(),
                        'statuses' => array('A'),
                        'variants' => false,
                        'plain' => true,
                        'feature_types' => ProductFeatures::GROUP,
                        'feature_id' => 0,
                        'display_on' => '',
                        'exclude_group' => false,
                        'exclude_filters' => false,
                        'page' => 1,
                        'items_per_page' => '10',
                        'variants_selected_only' => false,
                        'get_descriptions' => true,
                        'total_items' => '1',
                        'existent_only' => false,
                        'skip_variants_threshould' => false,
                        'variants_only' => null,
                    ),
                ),
            )),
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     * @datasetProvider dsProvider
     */
    public function testCreate($params, $result)
    {
        $actual = $this->api->create($params);
        $this->assertEquals($result, $actual);
    }

    public function providerCreate()
    {
        return array(
            // Try create with empty data
            array(array(), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_need_store')
                ),
            )),
            // Try create without feature type
            array(array(
                'company_id' => '1',
                'parent_id' => '0',
                'display_on_product' => 'Y',
                'display_on_catalog' => 'Y',
                'display_on_header' => 'N',
                'description' => 'Test feature',
                'lang_code' => 'en',
                'prefix' => '',
                'suffix' => '',
                'categories_path' => '166,174,190,191,193',
                'full_description' => '',
                'status' => 'A',
                'comparison' => 'N',
                'position' => '0',
                'feature_code' => '',
                'variants' => array()
            ), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_required_field', array('[field]' => 'feature_type'))
                ),
            )),
            // Try create
            array(array(
                'company_id' => '1',
                'feature_type' => ProductFeatures::GROUP,
                'parent_id' => '0',
                'display_on_product' => 'Y',
                'display_on_catalog' => 'Y',
                'display_on_header' => 'N',
                'description' => 'Test feature',
                'lang_code' => 'en',
                'prefix' => '',
                'suffix' => '',
                'categories_path' => '166,174,190,191,193',
                'full_description' => '',
                'status' => 'A',
                'comparison' => 'N',
                'position' => '0',
                'feature_code' => '',
                'variants' => array()
            ), array(
                'status' => Response::STATUS_CREATED,
                'data' => array('feature_id' => 20),
            )),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     * @datasetProvider dsProvider
     */
    public function testUpdate($id, $params, $updated_language, $result)
    {
        $actual = $this->api->update($id, $params);

        if ($actual['status'] == Response::STATUS_OK) {
            $res = $this->api->index($actual['data']['feature_id']);
            $this->assertEquals($updated_language, $res['data']);
        }

        $this->assertEquals($result, $actual);
    }

    public function providerUpdate()
    {
        return array(
            // Try update. Bad id.
            array(3,
                array(
                    'feature_type' => ProductFeatures::TEXT_SELECTBOX,
                    'display_on_product' => 'N',
                    'display_on_catalog' => 'N',
                    'display_on_header' => 'Y',
                    'description' => 'Test feature. New',
                ),
                array(),
                array(
                    'status' => Response::STATUS_BAD_REQUEST,
                    'data' => array(),
                )
            ),

            // Try update
            array(14,
                array(
                    'feature_type' => ProductFeatures::TEXT_SELECTBOX,
                    'display_on_product' => 'N',
                    'display_on_catalog' => 'N',
                    'display_on_header' => 'Y',
                    'description' => 'Test feature. New',
                ),
                array(
                    'feature_id' => '14',
                    'company_id' => '1',
                    'feature_type' => ProductFeatures::TEXT_SELECTBOX,
                    'parent_id' => '0',
                    'display_on_product' => 'N',
                    'display_on_catalog' => 'N',
                    'display_on_header' => 'Y',
                    'description' => 'Test feature. New',
                    'lang_code' => 'en',
                    'prefix' => '',
                    'suffix' => '',
                    'categories_path' => '166,174,190,191,193',
                    'full_description' => '',
                    'status' => 'A',
                    'comparison' => 'N',
                    'position' => '0',
                    'feature_code' => '',
                    'variants' => array()
                ),
                array(
                    'status' => Response::STATUS_OK,
                    'data' => array(
                        'feature_id' => 14,
                    )
                )
            ),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     * @datasetProvider dsProvider
     */
    public function testDelete($id, $result)
    {
        $actual = $this->api->delete($id);
        $this->assertEquals($result, $actual);

        if ($actual['status'] == Response::STATUS_OK) {
            $actual = $this->api->delete($id);
            $this->assertEquals($actual, array('status' => Response::STATUS_NOT_FOUND, 'data' => array()));
        }
    }

    public function providerDelete()
    {
        return array(
            // Try delete with empty id
            array('', array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try delete with nonexistent id
            array(1, array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try delete
            array(14, array(
                'status' => Response::STATUS_NO_CONTENT,
                'data' => array(),
            )),
        );
    }
}
